<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone_number', 'email', 'first_name', 'last_name', 'country_id', 'gender', 'password', 'activation_code');

    public function clientable()
    {
        return $this->morphTo();
    }

    public function categories()
    {
        return $this->hasMany('App\Models\Category');
    }

    public function feedbacks()
    {
        return $this->hasMany('App\Models\Feedack');
    }

    public function members()
    {
        return $this->hasMany('App\Models\Member');
    }

}